// priority: 3

let 触发时事件列表 = [
  "net.minecraftforge.event.entity.living.LivingHurtEvent",
  "net.minecraftforge.event.entity.living.LivingDeathEvent",
  "net.minecraftforge.event.entity.living.LivingEvent$LivingTickEvent"
];

触发时事件列表.forEach(e => {
  NativeEvents.onEvent(Java.loadClass(e), e => {
    修复假死(e.entity, e.server);
  });
});

//修改实体标签,被添加标签的生物不会被船和矿车困住
ServerEvents.tags("entity_type", e => {
  e.add("enhancedai:can_use_anti_cheese", 不受陷阱影响生物);
});

// 海王弓支持附魔经验修复和耐久
ServerEvents.tags("item", e => {
  e.add("minecraft:enchantable/durability", "aquaculture:neptunium_bow");
  e.add("minecraft:enchantable/vanishing", "aquaculture:neptunium_bow");
});

let 修复假死 = (实体, s) => {

  if (!实体 || !实体.isLiving() || 实体.level.isClientSide()) {
    return false;
  }

  let 当前生命值 = 实体.health;
  let 实体类型ID = String(实体.type);

  if (Number.isNaN(当前生命值) || 当前生命值 < 0) {
    实体.health = 0.0;
    console.warn(`[假死修复] 已将实体 "${实体类型ID}" (位于 ${Math.floor(实体.x)}, ${Math.floor(实体.y)}, ${Math.floor(实体.z)}) 的无效生命值 (${当前生命值}) 修正为 0。`);

    if (s && typeof s.tell === "function") {
      let 通知文本 = Text.of("[系统] ").aqua()
        .append(Text.of("检测并修复了一个假死实体 ").gold())
        .append(Text.of(`(${实体类型ID})`).yellow())
        .append(Text.of(` (位于 ${Math.floor(实体.x)}, ${Math.floor(实体.y)}, ${Math.floor(实体.z)}) 的无效生命值 (${当前生命值}) 修正为 0。`));
      s.tell(通知文本);
    }
    return true;
  }
  return false;
};

LevelEvents.loaded(e => {
  let s = e.server;
  let 已修复数量 = 0;

  e.level.getEntities().forEach(单个实体 => {
    if (修复假死(单个实体, s)) {
      已修复数量++;
    }
  });

  if (已修复数量 > 0) {
    console.log(`巡查完毕，共修复了 ${已修复数量} 个实体的生命值。`);
  }
});

// 保护实体不受伤
EntityEvents.hurt(e => {
  let 实体 = e.entity;
  let 来源 = e.source;
  let 实体类型ID = String(实体.type);

  if (来源.player && 受保护生物免受玩家伤害.includes(实体类型ID)) {
    e.cancel(); // 取消事件
  }
});

// 取消耕地踩踏破坏 - 但有条件：玩家靴子需有“保护”附魔
BlockEvents.farmlandTrampled(e => {
  if (e.entity && e.entity.isPlayer()) {
    let p = e.entity;
    let 穿的靴子 = p.feetArmorItem;

    if (穿的靴子 && !穿的靴子.isEmpty()) {
      let 保护等级 = 穿的靴子.getEnchantmentLevel("minecraft:protection");

      if (保护等级 > 0) {
        p.tell(Text.of("幸好你靴子有保护附魔,耕地免受破坏！").green());
        e.cancel();
      }
    }
  }
});

// 掉落物处理
EntityEvents.spawned(e => {
  let 实体 = e.entity;

  if (实体.type === "minecraft:item") {
    let 物品NBT = 实体.nbt;
    let 由玩家扔出 = false;

    if (物品NBT) {
      if (物品NBT.Thrower) {
        由玩家扔出 = true;
      } else if (物品NBT.Owner) {
        由玩家扔出 = true;
      }
    }

    if (!由玩家扔出 && 物品NBT && 物品NBT.Item && typeof 物品NBT.Item.id === "string") {
      if (发光掉落物.includes(物品NBT.Item.id)) {
        实体.mergeNbt({
          NoAI: 1,
          Glowing: 1,
          NoGravity: 1,
          Age: -32768,
          Motion: [0.0, 0.0, 0.0]
        });
      }
    }
  }

  if (实体.type === "minecraft:item") {
    if (实体.nbt && 实体.nbt.Item && typeof 实体.nbt.Item.id === "string" && 无敌物品列表.includes(实体.nbt.Item.id.toString())) {
      实体.attack(-21e10);// 给予-21e10的伤害实现无敌
    }
  }
});

// 特定工具破坏方块
BlockEvents.broken(e => {
  if (受保护方块.includes(e.block.id)) {
    if (!破坏受保护方块工具.includes(e.player.mainHandItem.id)) {
      e.player.tell(Text.of("你需要使用星光破坏锤或永恒稿破开它！").color("yellow").italic(true));
      e.cancel();
    }
  }
});

// 登出时保存生命值
PlayerEvents.loggedOut(e => {
  let p = e.player;
  let pDATA = "player_HP";

  if (p.isAlive()) {
    p.persistentData.putDouble(pDATA, p.health);
  }
});

// 修复登录最大生命值
PlayerEvents.loggedIn(e => {
  let p = e.player;
  let pDATA = "player_HP";

  if (p.persistentData.contains(pDATA)) {
    let 已存储生命值 = p.persistentData.getDouble(pDATA);

    e.server.scheduleInTicks(1, () => {
      if (p && p.isAlive()) {
        p.health = Math.max(已存储生命值, 0);
        p.persistentData.remove(pDATA);
      } else if (p && p.persistentData.contains(pDATA)) {
        p.persistentData.remove(pDATA);
      }
    });
  }
});

// 修复维度传送后经验值显示
NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.player.PlayerEvent$PlayerChangedDimensionEvent"), e => {
  let p = e.getEntity();
  if (!p || p.isFake() || !p.server) {
    return;
  }
  p.giveExperiencePoints(1);
  p.giveExperiencePoints(-1);
});

// 修复装配矿车塞进衣壳体导致刷物品
NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.player.PlayerInteractEvent$RightClickBlock"), e => {
  let p = e.getEntity();
  let 世界 = e.getLevel();
  let 方块坐标 = e.getPos();

  if (!p || !世界 || !方块坐标) return;

  let 方块 = 世界.getBlockState(方块坐标).getBlock();
  let 注册表键 = $注册中心.BLOCKS.getKey(方块);
  let 方块ID = 注册表键.toString();
  let 主手 = p.getMainHandItem();
  let 副手 = p.getOffhandItem();
  let 主手物品ID = 主手.id ? 主手.id.toString() : "空";
  let 副手物品ID = 副手.id ? 副手.id.toString() : "空";
  let 应取消 = false;

  if (方块ID === "alexsmobs:capsid") {
    if (主手物品ID === "create:minecart_contraption" || 副手物品ID === "create:minecart_contraption") {
      应取消 = true;
    }
  }

  if (应取消) {
    e.setCanceled(true);
  }
});

BlockEvents.rightClicked(e => {
  if (e.level.isClientSide() || !e.server) {
    return;
  }

  let p = e.player;
  let 方块 = e.block;
  let 方块ID = 方块.id.toString();

  if (!p || !方块 || !方块ID) return;

  let 主手 = p.getMainHandItem();
  let 副手 = p.getOffhandItem();
  let 主手物品ID = 主手.id ? 主手.id.toString() : "空";
  let 副手物品ID = 副手.id ? 副手.id.toString() : "空";

  let 应该处理交互 = false;
  let 当前提示信息 = null;
  let 当前NBT标记 = null;

  if (方块ID === "alexsmobs:capsid") {
    if (主手物品ID === "create:minecart_contraption" || 副手物品ID === "create:minecart_contraption") {
      应该处理交互 = true;
      当前提示信息 = "§4进不去，怎么都进不去好吧！";
      当前NBT标记 = "kjs_capsid_prompt";
    }
  }

  if (应该处理交互 && 当前提示信息 && 当前NBT标记) {
    if (!p.persistentData.contains(当前NBT标记)) {
      p.tell(当前提示信息);
      p.persistentData.putBoolean(当前NBT标记, true);

      let s = e.server;
      if (s && typeof s.scheduleInTicks === "function") {
        let pUUID = p.uuid;
        if (pUUID) {
          s.scheduleInTicks(1, () => {
            let 清理 = s.getPlayer(pUUID);
            if (清理) {
              清理.persistentData.remove(当前NBT标记);
            }
          });
        }
      }
    }
  }
});